/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.system.RequestProcessor;
import org.das2.util.LoggerManager;

public abstract class RunLaterListener
implements PropertyChangeListener,
Runnable {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.dom");
    PropertyChange node;
    String propertyName;
    boolean immediatelyAfter;
    int invocationCount = 0;

    public RunLaterListener(String propertyName, PropertyChange node, boolean immediatelyAfter) {
        this.node = node;
        this.propertyName = propertyName;
        this.immediatelyAfter = immediatelyAfter;
        if (propertyName != null) {
            this.node.addPropertyChangeListener(propertyName, this);
        } else {
            this.node.addPropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ++this.invocationCount;
        if (this.propertyName != null) {
            this.node.removePropertyChangeListener(this.propertyName, this);
        } else {
            this.node.removePropertyChangeListener(this);
        }
        if (this.invocationCount > 1) {
            return;
        }
        if (this.immediatelyAfter) {
            try {
                this.run();
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "https://sourceforge.net/p/autoplot/bugs/2456/: error occurred which would block other listeners", ex);
            }
        } else {
            RequestProcessor.invokeLater((Runnable)this);
        }
    }

    @Override
    public abstract void run();

    public static interface PropertyChange {
        public void addPropertyChangeListener(String var1, PropertyChangeListener var2);

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(String var1, PropertyChangeListener var2);
    }
}

